package centralSystem;

/**
 * 
 * This class represents an office queue
 * 
 * @author simone
 *
 */
public class Queue {

	private int totalClient;
	private int nextClient=1;
	
	/**
	 * Add a client to this queue
	 */
	public void addClient() {
		this.totalClient++;
	}
	
	/**
	 * 
	 * @return: number of clients added since
	 * queue's initialization
	 */
	public int getTotalClient() {
		return totalClient;
	}
	
	/**
	 * Notifies that a client in this queue has
	 * just been served, with a consequent decreasing
	 * in awating clients number
	 */
	public void clientServed(){
		if (nextClient<=totalClient) {
			nextClient++;
		}
	}
	
	/**
	 * 
	 * @return: number of first awaiting client
	 */
	public int getNextClient() {
		return nextClient;
	}
}
